/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import org.example.logic.ChillModeParameters;
import org.example.logic.ChillModeUI;
import org.example.logic.DataRecovery;
import org.example.logic.DataRepairer;
import org.example.logic.DeleteDoubleAndBuggyData;
import org.example.logic.MemoryImageCreator;
import org.example.logic.ProgressCallback;

public class ChillMode {
    public void startChillMode(ChillModeParameters cmp, TextArea statusText, ProgressCallback callback, ChillModeUI cmu, Button startButton) {
        this.pushMessage(statusText, "Erstelle Speicherabbild...");
        MemoryImageCreator memoryImageCreator = new MemoryImageCreator(cmp.getInputPath(), cmp.getImagePath() + "diskImage.img");
        memoryImageCreator.saveDiskImage(cmp.getInputPath(), cmp.getImagePath() + "\\diskImage.img", callback);
        this.pushMessage(statusText, "Speicherabbild erstellt.");
        callback.updateProgress(100);
        if (cmp.videos || cmp.picturtes) {
            this.pushMessage(statusText, "Starting Recovery...");
            DataRecovery dataRecovery = new DataRecovery();
            this.pushMessage(statusText, cmp.getImagePath());
            dataRecovery.startRecovery(cmp.getImagePath() + "\\diskImage.img", cmp.outputPath, cmp.getPictures(), cmp.getVideos(), statusText, cmu);
            this.pushMessage(statusText, "Recovery done.");
        }
        if (cmp.getRepairDef()) {
            this.pushMessage(statusText, "Starting repair...");
            DataRepairer dataRep = new DataRepairer(cmp.getInputPath(), cmp.getOutputPathPath());
            dataRep.startRepair(cmp.getOutputPathPath(), cmp.getOutputPathPath(), cmp.getPictures(), cmp.getVideos(), statusText, cmu);
            this.pushMessage(statusText, "Repairing done.");
        }
        if (cmp.getDelDefect()) {
            this.pushMessage(statusText, "Starting cleaning...");
            DeleteDoubleAndBuggyData deleteDoubleAndBuggyData = new DeleteDoubleAndBuggyData();
            deleteDoubleAndBuggyData.startDeletion(cmp.outputPath, statusText, cmu);
            this.pushMessage(statusText, "Deletion done");
        }
        Platform.runLater(() -> {
            startButton.setDisable(false);
            startButton.setText("Dateien wiederherstellen");
        });
        this.pushMessage(statusText, "Program done!");
    }

    private void pushMessage(TextArea status, String msg) {
        System.out.println(msg);
        status.appendText(msg + "\n");
    }
}

