/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.control.TextArea;
import org.example.logic.ChillModeUI;

public class DataRecovery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecovery(String inputFolderPath, String outputFolderPath, boolean pictures, boolean videos, TextArea statusText, ChillModeUI cmu) {
        block27: {
            Future<List> videosFuture;
            block28: {
                Future<List> imagesFuture;
                block26: {
                    ExecutorService executor = Executors.newFixedThreadPool(2);
                    imagesFuture = null;
                    videosFuture = null;
                    try {
                        Platform.runLater(() -> statusText.appendText("Wiederherstellung l\u00e4uft...\n"));
                        File outputDir = new File(outputFolderPath);
                        if (!outputDir.exists()) {
                            outputDir.mkdirs();
                        }
                        byte[] data = DataRecovery.readFileToByteArray(inputFolderPath);
                        int totalSteps = (pictures ? 1 : 0) + (videos ? 1 : 0);
                        int currentStep = 0;
                        if (pictures) {
                            imagesFuture = executor.submit(() -> DataRecovery.extractJPEGImages(data, statusText, progress -> Platform.runLater(() -> cmu.getProgressBarRecoverPic().setProgress(progress.doubleValue()))));
                        }
                        if (videos) {
                            videosFuture = executor.submit(() -> DataRecovery.extractVideos(data, statusText, progress -> Platform.runLater(() -> cmu.getProgressBarRecoverVid().setProgress(progress.doubleValue()))));
                        }
                        if (pictures) {
                            List images = (List)imagesFuture.get();
                            DataRecovery.saveImages(images, outputFolderPath);
                            while (!imagesFuture.isDone()) {
                                try {
                                    this.wait(1000L);
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage());
                                }
                            }
                        }
                        if (videos) {
                            List videosData = (List)videosFuture.get();
                            DataRecovery.saveVideos(videosData, outputFolderPath);
                            int finalCurrentStep = ++currentStep;
                            while (!videosFuture.isDone()) {
                                try {
                                    this.wait(1000L);
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                    finally {
                        executor.shutdown();
                    }
                    if (!pictures || !videos) break block26;
                    while (!imagesFuture.isDone() && !videosFuture.isDone()) {
                        try {
                            this.wait(1000L);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                    break block27;
                }
                if (!pictures) break block28;
                while (!imagesFuture.isDone()) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                break block27;
            }
            if (!videos) break block27;
            while (!videosFuture.isDone()) {
                try {
                    this.wait(1000L);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    private static byte[] readFileToByteArray(String filePath) throws IOException {
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    private static List<byte[]> extractJPEGImages(byte[] data, TextArea statusText, Consumer<Double> progressUpdater) {
        int endIndex;
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        byte[] startMarker = new byte[]{-1, -40};
        byte[] endMarker = new byte[]{-1, -39};
        int startIndex = 0;
        int totalSize = data.length;
        while (startIndex < totalSize && (startIndex = DataRecovery.findMarker(data, startMarker, startIndex)) != -1 && (endIndex = DataRecovery.findMarker(data, endMarker, startIndex)) != -1) {
            byte[] imageData = new byte[(endIndex += endMarker.length) - startIndex];
            System.arraycopy(data, startIndex, imageData, 0, imageData.length);
            images.add(imageData);
            startIndex = endIndex;
            double progress = (double)startIndex / (double)totalSize;
            Platform.runLater(() -> progressUpdater.accept(progress));
        }
        Platform.runLater(() -> statusText.appendText("Wiederherstellung l\u00e4uft: " + images.size() + " Bilder gefunden.\n"));
        return images;
    }

    private static int findMarker(byte[] data, byte[] marker, int start) {
        for (int i = start; i <= data.length - marker.length; ++i) {
            boolean found = true;
            for (int j = 0; j < marker.length; ++j) {
                if (data[i + j] == marker[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private static void saveImages(List<byte[]> images, String outputDirPath) throws IOException {
        for (int i = 0; i < images.size(); ++i) {
            String fileName = String.format("image_%03d.jpg", i);
            File outputFile = new File(outputDirPath, fileName);
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                fos.write(images.get(i));
                continue;
            }
        }
    }

    public static List<VideoFile> extractVideos(byte[] data, TextArea statusText, Consumer<Double> progressUpdater) {
        List<VideoFile> videos = DataRecovery.extractVideoFiles(data, progressUpdater);
        Platform.runLater(() -> statusText.appendText("Wiederherstellung l\u00e4uft: " + videos.size() + " Videos gefunden.\n"));
        return videos;
    }

    private static List<VideoFile> extractVideoFiles(byte[] data, Consumer<Double> progressUpdater) {
        int headerIndex;
        ArrayList<VideoFile> videos = new ArrayList<VideoFile>();
        byte[] mp4Header = new byte[]{0, 0, 0, 24, 102, 116, 121, 112};
        byte[] aviHeader = new byte[]{82, 73, 70, 70};
        byte[] movHeader = new byte[]{109, 111, 111, 118};
        byte[] mpegHeader = new byte[]{0, 0, 1, -70};
        int startIndex = 0;
        while (startIndex < data.length && (headerIndex = DataRecovery.findHeader(data, startIndex, mp4Header, aviHeader, movHeader, mpegHeader)) != -1) {
            String fileType = DataRecovery.getFileType(data, headerIndex);
            int endIndex = DataRecovery.estimateVideoEnd(data, headerIndex);
            byte[] videoData = new byte[endIndex - headerIndex];
            System.arraycopy(data, headerIndex, videoData, 0, videoData.length);
            videos.add(new VideoFile(fileType, videoData));
            startIndex = endIndex;
            double progress = (double)startIndex / (double)data.length;
            Platform.runLater(() -> progressUpdater.accept(progress));
        }
        return videos;
    }

    private static int findHeader(byte[] data, int startIndex, byte[] ... headers) {
        for (int i = startIndex; i < data.length; ++i) {
            for (byte[] header : headers) {
                if (!DataRecovery.matchesHeader(data, i, header)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean matchesHeader(byte[] data, int position, byte[] header) {
        if (position + header.length > data.length) {
            return false;
        }
        for (int i = 0; i < header.length; ++i) {
            if (data[position + i] == header[i]) continue;
            return false;
        }
        return true;
    }

    private static String getFileType(byte[] data, int index) {
        if (DataRecovery.matchesHeader(data, index, new byte[]{0, 0, 0, 24, 102, 116, 121, 112})) {
            return "mp4";
        }
        if (DataRecovery.matchesHeader(data, index, new byte[]{82, 73, 70, 70})) {
            return "avi";
        }
        if (DataRecovery.matchesHeader(data, index, new byte[]{109, 111, 111, 118})) {
            return "mov";
        }
        if (DataRecovery.matchesHeader(data, index, new byte[]{0, 0, 1, -70})) {
            return "mpeg";
        }
        return "unknown";
    }

    private static int estimateVideoEnd(byte[] data, int startIndex) {
        for (int i = startIndex + 1024; i < data.length - 1024; ++i) {
            if (!DataRecovery.matchesHeader(data, i, new byte[]{0, 0, 0, 24, 102, 116, 121, 112}) && !DataRecovery.matchesHeader(data, i, new byte[]{82, 73, 70, 70}) && !DataRecovery.matchesHeader(data, i, new byte[]{109, 111, 111, 118}) && !DataRecovery.matchesHeader(data, i, new byte[]{0, 0, 1, -70})) continue;
            return i;
        }
        return Math.min(data.length, startIndex + 0x6400000);
    }

    private static void saveVideos(List<VideoFile> videos, String outputDirPath) throws IOException {
        for (int i = 0; i < videos.size(); ++i) {
            VideoFile video = videos.get(i);
            String fileName = String.format("video_%03d.%s", i, video.getFileType());
            File outputFile = new File(outputDirPath, fileName);
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                fos.write(video.getData());
                continue;
            }
        }
    }

    private static class VideoFile {
        private final String fileType;
        private final byte[] data;

        public VideoFile(String fileType, byte[] data) {
            this.fileType = fileType;
            this.data = data;
        }

        public String getFileType() {
            return this.fileType;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

