/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.TextArea;
import org.example.logic.ChillModeUI;
import org.example.logic.FileUtils;

public class DeleteDoubleAndBuggyData {
    List<File> imageFiles;
    List<File> filesToDelete;

    public void startDeletion(String directoryPath, TextArea statusText, ChillModeUI cmu) {
        this.imageFiles = new ArrayList<File>();
        this.filesToDelete = new ArrayList<File>();
        try {
            File directory = new File(directoryPath);
            if (!directory.exists() || !directory.isDirectory()) {
                statusText.setText("Ung\u00fcltiges Verzeichnis!");
                System.out.println("Ung\u00fcltiges Verzeichnis!");
                return;
            }
            FileUtils fileUtils = new FileUtils(this.imageFiles, this.filesToDelete);
            fileUtils.analyzePictures(directory, cmu);
            int totalFiles = this.filesToDelete.size();
            for (int i = 0; i < totalFiles; ++i) {
                double progress = (double)(i + 1) / (double)totalFiles;
                File file = this.filesToDelete.get(i);
                file.delete();
                Platform.runLater(() -> cmu.getProgressBarRemove().setProgress(progress));
            }
            this.filesToDelete.clear();
            this.imageFiles.clear();
            FileUtils videoFileUtils = new FileUtils(this.imageFiles, this.filesToDelete);
            videoFileUtils.analyzeVideos(directory);
            for (File file : this.filesToDelete) {
                if (file.delete()) {
                    System.out.println("Gel\u00f6scht: " + file.getName());
                    continue;
                }
                System.out.println("Fehler beim L\u00f6schen: " + file.getName());
            }
            statusText.appendText("Bereinigung abgeschlossen! Es wurden " + this.filesToDelete.size() + " Bilder gel\u00f6scht \n");
            System.out.println("Bereinigung abgeschlossen!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

