/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javax.imageio.ImageIO;
import org.example.logic.ChillModeUI;

public class FileUtils {
    List<File> imageFiles;
    List<File> filesToDelete;

    public FileUtils(List<File> mediaFiles, List<File> filesToDelete) {
        this.imageFiles = mediaFiles;
        this.filesToDelete = filesToDelete;
    }

    public void analyzeVideos(File directory) throws Exception {
        HashMap<String, File> videoHashes = new HashMap<String, File>();
        File[] files = directory.listFiles();
        boolean count = false;
        for (File file : files) {
            try {
                if (!file.isFile() || !this.isVideo(file)) continue;
                if (!this.isVideoValid(file)) {
                    System.out.println("Besch\u00e4digtes Video gefunden: " + file.getName());
                    this.filesToDelete.add(file);
                    continue;
                }
                String fileHash = FileUtils.calculateFileHash(file, "SHA-256");
                if (videoHashes.containsKey(fileHash)) {
                    System.out.println("Doppelte Datei gefunden: " + file.getName());
                    this.filesToDelete.add(file);
                    continue;
                }
                videoHashes.put(fileHash, file);
                this.imageFiles.add(file);
            }
            catch (Exception e) {
                System.out.println("Fehler beim Analysieren des Videos: " + file.getName());
                this.filesToDelete.add(file);
            }
        }
    }

    private boolean isVideo(File file) {
        String[] videoExtensions = new String[]{".mp4", ".avi", ".mkv", ".mov", ".flv", ".wmv", ".mpeg"};
        String fileName = file.getName().toLowerCase();
        for (String extension : videoExtensions) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private boolean isVideoValid(File videoFile) {
        try {
            System.out.println("Starte FFMPEG");
            ProcessBuilder processBuilder = new ProcessBuilder("ffmpeg", "-v", "error", "-i", videoFile.getAbsolutePath(), "-f", "null", "-", "2>&1");
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectOutput();
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void analyzePictures(File directory, ChillModeUI cmu) throws Exception {
        Platform.runLater(() -> cmu.progressAnalyze.setProgress(0.0));
        HashMap<String, File> imageHashes = new HashMap<String, File>();
        File[] files = directory.listFiles();
        System.out.println("Start analysing pics");
        int totalFiles = files.length;
        for (int i = 0; i < totalFiles; ++i) {
            File file = files[i];
            double progress = (double)(i + 1) / (double)totalFiles;
            double iforptimt = i;
            Platform.runLater(() -> cmu.progressAnalyze.setProgress(progress));
            if (!file.isFile() || !FileUtils.isImage(file)) continue;
            try {
                BufferedImage image = ImageIO.read(file);
                if (image == null) {
                    this.filesToDelete.add(file);
                    continue;
                }
                String fileHash = FileUtils.calculateFileHash(file, "MD5");
                if (imageHashes.containsKey(fileHash)) {
                    this.filesToDelete.add(file);
                    continue;
                }
                imageHashes.put(fileHash, file);
                this.imageFiles.add(file);
                continue;
            }
            catch (IOException e) {
                this.filesToDelete.add(file);
            }
        }
        System.out.println("loop analysing pics done");
    }

    private static boolean isImage(File file) {
        String[] imageExtensions = new String[]{".jpg", ".jpeg", ".png", ".bmp", ".gif", ".tiff"};
        String fileName = file.getName().toLowerCase();
        for (String ext : imageExtensions) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static String calculateFileHash(File file, String algorithm) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            byte[] byteArray = new byte[1024];
            while ((bytesRead = ((InputStream)fis).read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hashBytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }
}

