/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.control.Alert;
import javax.imageio.ImageIO;

public class ImageComparator {
    public void startGrouping(String inputFolderPath, String outputFolderPath, int sensitivity, int hashSize) {
        if (inputFolderPath.isEmpty() || outputFolderPath.isEmpty()) {
            this.showAlert("Fehler", "Bitte geben Sie sowohl einen Eingabe- als auch einen Ausgabeordner an.");
            return;
        }
        this.groupImages(inputFolderPath, outputFolderPath, sensitivity, hashSize);
    }

    private void showAlert(String title, String content) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setContentText(content);
        alert.showAndWait();
    }

    private void groupImages(String directoryPath, String outputFolder, int similarityThreshold, int imageSize) {
        File directory = new File(directoryPath);
        if (!directory.exists() || !directory.isDirectory()) {
            this.showAlert("Fehler", "Der angegebene Eingabeordner ist ung\u00fcltig.");
            return;
        }
        File outputDir = new File(outputFolder);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try {
            List<File> imageFiles = Arrays.asList(directory.listFiles());
            ArrayList<String> imageHashes = new ArrayList<String>();
            ArrayList groups = new ArrayList();
            for (File file : imageFiles) {
                if (!file.isFile() || !this.isImage(file)) continue;
                BufferedImage image = ImageIO.read(file);
                String hash = this.calculateImageHash(image, imageSize);
                imageHashes.add(hash);
            }
            ArrayList<File> currentGroup = new ArrayList<File>();
            for (int i = 0; i < imageFiles.size(); ++i) {
                String currentHash;
                if (!this.isImage(imageFiles.get(i))) continue;
                if (i == 0) {
                    currentGroup.add(imageFiles.get(i));
                    continue;
                }
                String previousHash = (String)imageHashes.get(i - 1);
                int distance = this.calculateHammingDistance(previousHash, currentHash = (String)imageHashes.get(i));
                if (distance < similarityThreshold) {
                    currentGroup.add(imageFiles.get(i));
                    continue;
                }
                groups.add(new ArrayList(currentGroup));
                currentGroup.clear();
                currentGroup.add(imageFiles.get(i));
            }
            if (!currentGroup.isEmpty()) {
                groups.add(currentGroup);
            }
            for (int groupId = 0; groupId < groups.size(); ++groupId) {
                File groupDir = new File(outputFolder + File.separator + "group_" + (groupId + 1));
                groupDir.mkdirs();
                for (File file : (List)groups.get(groupId)) {
                    Files.copy(file.toPath(), new File(groupDir, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            System.out.println("Bilder erfolgreich gruppiert!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isImage(File file) {
        String[] imageExtensions = new String[]{".jpg", ".jpeg", ".png", ".bmp", ".gif", ".tiff"};
        String fileName = file.getName().toLowerCase();
        for (String ext : imageExtensions) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private String calculateImageHash(BufferedImage image, int imageSize) {
        image = this.resizeImage(image, imageSize, imageSize);
        BufferedImage grayImage = this.convertToGrayscale(image);
        StringBuilder hash = new StringBuilder();
        for (int y = 0; y < grayImage.getHeight(); ++y) {
            for (int x = 0; x < grayImage.getWidth() - 1; ++x) {
                int pixel2;
                int pixel1 = grayImage.getRGB(x, y) & 0xFF;
                if (pixel1 < (pixel2 = grayImage.getRGB(x + 1, y) & 0xFF)) {
                    hash.append("1");
                    continue;
                }
                hash.append("0");
            }
        }
        return hash.toString();
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        Image resizedImage = originalImage.getScaledInstance(width, height, 2);
        BufferedImage bufferedResizedImage = new BufferedImage(width, height, 10);
        Graphics2D g2d = bufferedResizedImage.createGraphics();
        g2d.drawImage(resizedImage, 0, 0, null);
        g2d.dispose();
        return bufferedResizedImage;
    }

    private BufferedImage convertToGrayscale(BufferedImage image) {
        BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics g = grayImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return grayImage;
    }

    private int calculateHammingDistance(String hash1, String hash2) {
        int distance = 0;
        for (int i = 0; i < hash1.length(); ++i) {
            if (hash1.charAt(i) == hash2.charAt(i)) continue;
            ++distance;
        }
        return distance;
    }
}

