/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class ImageInterpolation {
    public static BufferedImage interpolate(BufferedImage damagedImage, int missingX, int missingY) {
        int width = damagedImage.getWidth();
        int height = damagedImage.getHeight();
        int[] pixelValues = new int[]{damagedImage.getRGB(missingX - 1, missingY - 1), damagedImage.getRGB(missingX + 1, missingY - 1), damagedImage.getRGB(missingX - 1, missingY + 1), damagedImage.getRGB(missingX + 1, missingY + 1)};
        Color topLeft = new Color(pixelValues[0]);
        Color topRight = new Color(pixelValues[1]);
        Color bottomLeft = new Color(pixelValues[2]);
        Color bottomRight = new Color(pixelValues[3]);
        int r = (topLeft.getRed() + topRight.getRed() + bottomLeft.getRed() + bottomRight.getRed()) / 4;
        int g = (topLeft.getGreen() + topRight.getGreen() + bottomLeft.getGreen() + bottomRight.getGreen()) / 4;
        int b = (topLeft.getBlue() + topRight.getBlue() + bottomLeft.getBlue() + bottomRight.getBlue()) / 4;
        damagedImage.setRGB(missingX, missingY, new Color(r, g, b).getRGB());
        return damagedImage;
    }
}

