/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import org.example.logic.ChillModeUI;
import org.example.logic.FileUtils;

public class ImageRepair {
    List<File> imageFiles;
    List<File> filesToRepair;

    public void repairImages(String directoryPath, String outputPath, ChillModeUI cmu) {
        try {
            this.imageFiles = new ArrayList<File>();
            this.filesToRepair = new ArrayList<File>();
            File directory = new File(directoryPath);
            if (!directory.exists() || !directory.isDirectory()) {
                System.out.println("Ung\u00fcltiges Verzeichnis!");
                return;
            }
            FileUtils fileUtils = new FileUtils(this.imageFiles, this.filesToRepair);
            fileUtils.analyzePictures(directory, cmu);
            int totalFiles = this.filesToRepair.size();
            for (int i = 0; i < totalFiles; ++i) {
                double progress = (double)(i + 1) / (double)totalFiles;
                File file = this.filesToRepair.get(i);
                ImageRepair.repairJPEGHeader(file, this.imageFiles.get(0));
                Platform.runLater(() -> cmu.getProgressBarRepair().setProgress(progress));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void repairJPEGHeader(File damagedImage, File intactImage) throws IOException {
        byte[] intactData = Files.readAllBytes(intactImage.toPath());
        byte[] damagedData = Files.readAllBytes(damagedImage.toPath());
        if (damagedData.length > 10) {
            System.arraycopy(intactData, 0, damagedData, 0, 10);
        }
        try (FileOutputStream fos = new FileOutputStream(damagedImage);){
            fos.write(damagedData);
        }
    }
}

