/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import org.example.logic.ProgressCallback;
import org.example.logic.RawDiskReader;

public class MemoryImageCreator
implements Runnable {
    private final String diskPath;
    private final String imagePath;

    public MemoryImageCreator(String diskPath, String imagePath) {
        this.diskPath = diskPath;
        this.imagePath = imagePath;
    }

    public native void saveDiskImage(String var1, String var2, ProgressCallback var3);

    @Override
    public void run() {
        System.out.println("Starte RawDiskReader...");
        System.out.println("Disk Path: " + this.diskPath);
        System.out.println("Image Path: " + this.imagePath);
        ProgressCallback callback = new ProgressCallback(){

            @Override
            public void updateProgress(int progress) {
                System.out.println("Fortschritt: " + progress + "%");
            }
        };
        RawDiskReader reader = new RawDiskReader();
        try {
            System.out.println("Beginne mit der Erstellung des Images...");
            long startTime = System.currentTimeMillis();
            reader.saveDiskImage(this.diskPath, this.imagePath, callback);
            long endTime = System.currentTimeMillis();
            System.out.println("Das Disk-Image wurde erfolgreich gespeichert!");
            System.out.println("Dauer: " + (endTime - startTime) + " ms");
        }
        catch (Exception e) {
            System.err.println("Fehler beim Speichern des Disk-Images:");
            e.printStackTrace();
        }
    }

    static {
        System.loadLibrary("RawDiskLib");
    }
}

