/*
 * Decompiled with CFR 0.152.
 */
package org.example.logic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.scene.control.ProgressBar;
import org.example.logic.FileUtils;

public class VideoRepair {
    public void repairVideos(String directoryPath, String outputPath, ProgressBar progressBarRepair) {
        try {
            ArrayList<File> imageFiles = new ArrayList<File>();
            ArrayList<File> filesToDelete = new ArrayList<File>();
            File directory = new File(directoryPath);
            if (!directory.exists() || !directory.isDirectory()) {
                System.out.println("Ung\u00fcltiges Verzeichnis!");
                return;
            }
            FileUtils fileUtils = new FileUtils(imageFiles, filesToDelete);
            fileUtils.analyzeVideos(directory);
            int i = 0;
            for (File file : filesToDelete) {
                VideoRepair.repairVideo(file);
                double progress = ++i / filesToDelete.size();
                Platform.runLater(() -> progressBarRepair.setProgress(progress));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean repairVideo(File videoFile) {
        try {
            File repairedFile = new File(videoFile.getParent(), "repaired_" + videoFile.getName());
            ProcessBuilder processBuilder = new ProcessBuilder("ffmpeg", "-i", videoFile.getAbsolutePath(), "-c:v", "copy", "-c:a", "aac", "-b:a", "128k", "-loglevel", "debug", "-y", "-nostdin", repairedFile.getAbsolutePath());
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                if (videoFile.delete()) {
                    repairedFile.renameTo(videoFile);
                }
                return true;
            }
            repairedFile.delete();
            videoFile.delete();
            return false;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            videoFile.delete();
            return false;
        }
    }
}

