/*
 * Decompiled with CFR 0.152.
 */
package org.example.ui;

import java.io.File;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.example.logic.ChillMode;
import org.example.logic.ChillModeParameters;
import org.example.logic.ChillModeUI;

public class ChillModeTab {
    private TextField inputFolderPathField;
    private TextField outputFolderPathField;
    private TextField imageFolderPathField;
    private static TextArea logArea;
    private CheckBox expertModeCheckbox;
    private CheckBox viewLogCheckbox;
    HBox progressBarDRVBox;
    HBox progressBarDRPBox;
    HBox progressBarRepairBox;
    HBox progressBarRemoveBox;
    HBox progressBarAnalyzeBox;
    VBox additionalOptionsBox;
    private CheckBox pictures;
    private CheckBox videos;
    private CheckBox repair;
    private CheckBox remove;
    ProgressBar progressBarRecoverPic;
    ProgressBar progressBarRecoverVid;

    public Tab createTab(Stage primaryStage, TabPane tabPane) {
        Tab tab = new Tab("Chill Mode");
        BorderPane layout = new BorderPane();
        layout.setPadding(new Insets(20.0));
        layout.setStyle("-fx-background-color: #f4f4f9;");
        Label instructions = new Label("Es wird ein Speicherabbild erstellt, danach werden die Bilder und Videos wiederhergestellt.");
        instructions.setStyle("-fx-font-size: 14px; -fx-text-fill: #333;");
        this.expertModeCheckbox = new CheckBox("Expertenmodus");
        this.expertModeCheckbox.setStyle("-fx-font-weight: bold;");
        HBox expertModeBox = new HBox(new Node[]{this.expertModeCheckbox});
        expertModeBox.setPadding(new Insets(5.0));
        expertModeBox.setAlignment(Pos.TOP_RIGHT);
        this.expertModeCheckbox.setOnAction(e -> this.toggleExpertTabs(tabPane));
        HBox topSection = new HBox();
        topSection.setPadding(new Insets(10.0));
        topSection.setSpacing(10.0);
        topSection.setAlignment(Pos.CENTER_LEFT);
        topSection.getChildren().addAll((Object[])new Node[]{instructions, expertModeBox});
        layout.setTop((Node)topSection);
        VBox middleSection = new VBox(20.0);
        middleSection.setPadding(new Insets(10.0));
        this.inputFolderPathField = new TextField();
        this.inputFolderPathField.setPromptText("Speicherort der Daten...");
        Button inputFolderButton = new Button("Durchsuchen...");
        inputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.inputFolderPathField));
        HBox inputFolderBox = new HBox(10.0, new Node[]{new Label("Speicherort der gel\u00f6schten Daten:*"), this.inputFolderPathField, inputFolderButton});
        HBox.setHgrow((Node)this.inputFolderPathField, (Priority)Priority.ALWAYS);
        this.imageFolderPathField = new TextField();
        this.imageFolderPathField.setPromptText("Speicherort f\u00fcr das Speicherabbild...");
        Button imageFolderButton = new Button("Durchsuchen...");
        imageFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.imageFolderPathField));
        HBox imageFolderBox = new HBox(10.0, new Node[]{new Label("Speicherort Speicherabbild:            "), this.imageFolderPathField, imageFolderButton});
        HBox.setHgrow((Node)this.imageFolderPathField, (Priority)Priority.ALWAYS);
        this.outputFolderPathField = new TextField();
        this.outputFolderPathField.setPromptText("Ausgabeordner der Dateien...");
        Button outputFolderButton = new Button("Durchsuchen...");
        outputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.outputFolderPathField));
        HBox outputFolderBox = new HBox(10.0, new Node[]{new Label("Ausgabeordner:                             *"), this.outputFolderPathField, outputFolderButton});
        HBox.setHgrow((Node)this.outputFolderPathField, (Priority)Priority.ALWAYS);
        this.pictures = new CheckBox("Bilder");
        this.videos = new CheckBox("Videos");
        VBox mediaOptionsBox = new VBox(10.0, new Node[]{this.pictures, this.videos});
        mediaOptionsBox.setPadding(new Insets(10.0));
        mediaOptionsBox.setStyle("-fx-border-color: #ccc; -fx-border-radius: 8; -fx-padding: 10; -fx-background-radius: 8; -fx-background-color: #ffffff;");
        mediaOptionsBox.setMaxWidth(Double.MAX_VALUE);
        this.videos.setOnAction(e -> this.toggleVideo(tabPane));
        this.pictures.setOnAction(e -> this.togglePictures(tabPane));
        this.repair = new CheckBox("Bilder versuchen zu reparieren");
        this.remove = new CheckBox("Fehlerhafte und doppelte Bilder entfernen");
        this.additionalOptionsBox = new VBox(10.0, new Node[]{this.repair, this.remove});
        this.additionalOptionsBox.setPadding(new Insets(10.0));
        this.additionalOptionsBox.setStyle("-fx-border-color: #ccc; -fx-border-radius: 8; -fx-padding: 10; -fx-background-radius: 8; -fx-background-color: #ffffff;");
        this.additionalOptionsBox.setMaxWidth(Double.MAX_VALUE);
        this.additionalOptionsBox.setDisable(true);
        this.repair.setOnAction(e -> this.toggelRepair());
        this.remove.setOnAction(e -> this.toggelRemove());
        HBox optionsSection = new HBox(20.0);
        optionsSection.getChildren().addAll((Object[])new Node[]{mediaOptionsBox, this.additionalOptionsBox});
        HBox.setHgrow((Node)mediaOptionsBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.additionalOptionsBox, (Priority)Priority.ALWAYS);
        middleSection.getChildren().addAll((Object[])new Node[]{inputFolderBox, imageFolderBox, outputFolderBox, optionsSection});
        VBox bottomSection = new VBox(15.0);
        bottomSection.setPadding(new Insets(10.0));
        ProgressBar progressBarDI = new ProgressBar(0.0);
        progressBarDI.setPrefWidth(400.0);
        HBox progressBarDIBox = new HBox(10.0, new Node[]{progressBarDI, new Label("Image erstellen")});
        this.progressBarRecoverPic = new ProgressBar(0.0);
        this.progressBarRecoverPic.setPrefWidth(400.0);
        this.progressBarDRPBox = new HBox(10.0, new Node[]{this.progressBarRecoverPic, new Label("Bilder widerherstellen")});
        this.progressBarDRPBox.setDisable(true);
        this.progressBarRecoverVid = new ProgressBar(0.0);
        this.progressBarRecoverVid.setPrefWidth(400.0);
        this.progressBarDRVBox = new HBox(10.0, new Node[]{this.progressBarRecoverVid, new Label("Videos widerherstellen")});
        this.progressBarDRVBox.setDisable(true);
        ProgressBar progressBarRepair = new ProgressBar(0.0);
        progressBarRepair.setPrefWidth(400.0);
        this.progressBarRepairBox = new HBox(10.0, new Node[]{progressBarRepair, new Label("Bilder Reparieren")});
        this.progressBarRepairBox.setDisable(true);
        ProgressBar progressBarRemove = new ProgressBar(0.0);
        progressBarRemove.setPrefWidth(400.0);
        this.progressBarRemoveBox = new HBox(10.0, new Node[]{progressBarRemove, new Label("Bilder bereinigen")});
        this.progressBarRemoveBox.setDisable(true);
        VBox progressSectionLeft = new VBox(20.0, new Node[]{progressBarDIBox, this.progressBarDRPBox, this.progressBarDRVBox, this.progressBarRepairBox, this.progressBarRemoveBox});
        progressSectionLeft.setPadding(new Insets(10.0));
        progressSectionLeft.setStyle("-fx-border-color: #ccc; -fx-border-radius: 8; -fx-padding: 10; -fx-background-radius: 8; -fx-background-color: #ffffff;");
        progressSectionLeft.setMaxWidth(Double.MAX_VALUE);
        ProgressIndicator progressAnalyze = new ProgressIndicator(0.0);
        progressAnalyze.setPrefSize(50.0, 200.0);
        Label analyzeLabel = new Label("Daten analysieren");
        VBox progressSectionRight = new VBox(10.0, new Node[]{analyzeLabel, progressAnalyze});
        progressSectionRight.setPadding(new Insets(10.0));
        progressSectionRight.setStyle("-fx-border-color: #ccc; -fx-border-radius: 8; -fx-padding: 10; -fx-background-radius: 8; -fx-background-color: #ffffff;");
        progressSectionRight.setMaxWidth(Double.MAX_VALUE);
        progressSectionRight.setAlignment(Pos.CENTER);
        HBox progressSection = new HBox(20.0);
        progressSection.getChildren().addAll((Object[])new Node[]{progressSectionLeft, progressSectionRight});
        HBox.setHgrow((Node)progressSectionLeft, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)progressSectionRight, (Priority)Priority.ALWAYS);
        Button startButton = new Button("Dateien wiederherstellen");
        startButton.setStyle("-fx-background-color: #4caf50; -fx-text-fill: white; -fx-font-weight: bold;");
        startButton.setMaxWidth(Double.MAX_VALUE);
        logArea = new TextArea();
        logArea.setEditable(false);
        logArea.setWrapText(true);
        VBox logAreaBox = new VBox(10.0, new Node[]{new Label("Log:"), logArea});
        logAreaBox.setVisible(false);
        logAreaBox.setPadding(new Insets(10.0));
        logAreaBox.setMaxWidth(Double.MAX_VALUE);
        this.viewLogCheckbox = new CheckBox("Zeige Log Ausgaben an");
        this.viewLogCheckbox.setStyle("-fx-font-weight: bold;");
        HBox viewLogBox = new HBox(new Node[]{this.viewLogCheckbox});
        viewLogBox.setPadding(new Insets(5.0));
        viewLogBox.setAlignment(Pos.TOP_RIGHT);
        this.viewLogCheckbox.setOnAction(e -> {
            logAreaBox.setVisible(this.viewLogCheckbox.isSelected());
            if (this.viewLogCheckbox.isSelected()) {
                primaryStage.setHeight(910.0);
            } else {
                primaryStage.setHeight(670.0);
            }
        });
        bottomSection.getChildren().addAll((Object[])new Node[]{middleSection, progressSection, startButton, this.viewLogCheckbox, logAreaBox});
        layout.setCenter((Node)middleSection);
        layout.setBottom((Node)bottomSection);
        ChillModeParameters cmp = new ChillModeParameters();
        ChillModeUI cmu = new ChillModeUI();
        startButton.setOnAction(e -> new Thread(() -> {
            progressBarRemove.setProgress(0.0);
            progressBarDI.setProgress(0.0);
            progressBarRepair.setProgress(0.0);
            this.progressBarRecoverPic.setProgress(0.0);
            this.progressBarRecoverVid.setProgress(0.0);
            String diskPath = "\\\\.\\" + (this.inputFolderPathField.getText().isEmpty() ? "D:\\" : this.inputFolderPathField.getText());
            cmp.setInputPath(diskPath.substring(0, diskPath.length() - 1));
            cmp.setImagePath("\\\\.\\" + (this.imageFolderPathField.getText().isEmpty() ? "D:\\TestRecover" : this.imageFolderPathField.getText()));
            cmp.setOutputPathPath(this.outputFolderPathField.getText().isEmpty() ? "D:\\TestRecover" : this.outputFolderPathField.getText());
            if (cmp.getInputPath().isEmpty()) {
                this.pushMessage(logArea, "Fehler: Es muss ein Speicherort angegeben werden!");
                Platform.runLater(() -> {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("Fehler");
                    alert.setHeaderText("Sie m\u00fcssen den Speicherort w\u00e4hlen wo die wiederherzustellenden Daten sind.");
                    alert.setContentText("Bitte speicherort w\u00e4hlen!");
                    alert.showAndWait();
                });
                return;
            }
            if (cmp.getOutputPathPath().isEmpty()) {
                this.pushMessage(logArea, "Fehler: Es muss ein Speicherort angegeben werden!");
                Platform.runLater(() -> {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("Fehler");
                    alert.setHeaderText("Sie m\u00fcssen den Speicherort w\u00e4hlen wo die Daten gesdpeichert werden sollen.");
                    alert.setContentText("Bitte speicherort w\u00e4hlen!");
                    alert.showAndWait();
                });
                return;
            }
            cmp.setPictures(this.pictures.isSelected());
            cmp.setVideos(this.videos.isSelected());
            cmp.setDelDefect(this.remove.isSelected());
            cmp.setRepairDef(this.repair.isSelected());
            cmu.setProgressAnalyze(progressAnalyze);
            cmu.setProgressBarDI(progressBarDI);
            cmu.setProgressBarRecoverPic(this.progressBarRecoverPic);
            cmu.setProgressBarRecoverVid(this.progressBarRecoverVid);
            cmu.setProgressBarRemove(progressBarRemove);
            cmu.setProgressBarRepair(progressBarRepair);
            cmu.setStatusText(logArea);
            ChillMode delDABD = new ChillMode();
            Platform.runLater(() -> {
                startButton.setDisable(true);
                startButton.setText("Work in progress");
            });
            delDABD.startChillMode(cmp, logArea, progress -> Platform.runLater(() -> progressBarDI.setProgress((double)progress / 50.0)), cmu, startButton);
        }).start());
        tab.setContent((Node)layout);
        tab.setClosable(false);
        return tab;
    }

    private void chooseDirectory(Stage stage, TextField textField) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            textField.setText(selectedDirectory.getAbsolutePath());
        }
    }

    private void toggleExpertTabs(TabPane tabPane) {
        boolean isExpert = this.expertModeCheckbox.isSelected();
        for (Tab tab : tabPane.getTabs()) {
            if (tab.getText().equals("Chill Mode")) continue;
            tab.setDisable(!isExpert);
        }
    }

    private void toggleVideo(TabPane tabPane) {
        this.progressBarDRVBox.setDisable(!this.videos.isSelected());
        this.additionalOptionsBox.setDisable(!this.videos.isSelected() && !this.pictures.isSelected());
    }

    private void togglePictures(TabPane tabPane) {
        this.progressBarDRPBox.setDisable(!this.pictures.isSelected());
        this.additionalOptionsBox.setDisable(!this.videos.isSelected() && !this.pictures.isSelected());
    }

    private void toggelRepair() {
        this.progressBarRepairBox.setDisable(!this.repair.isSelected());
    }

    private void toggelRemove() {
        this.progressBarRemoveBox.setDisable(!this.remove.isSelected());
    }

    private void pushMessage(TextArea status, String msg) {
        System.out.println(msg);
        status.appendText(msg + "\n");
    }
}

