/*
 * Decompiled with CFR 0.152.
 */
package org.example.ui;

import java.io.File;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.example.logic.ChillModeUI;
import org.example.logic.DataRecovery;

public class DataRecoveryTab {
    private TextField inputFolderPathField;
    private TextField outputFolderPathField;
    private Slider sensitivitySlider;
    private Slider hashSizeSlider;
    private static TextArea logArea;

    public Tab createTab(Stage primaryStage) {
        Tab tab = new Tab("Daten widerherstellen");
        VBox layout = new VBox(10.0);
        Label inputFolderLabel = new Label("Speicherabbild (img):");
        this.inputFolderPathField = new TextField();
        Button inputFolderButton = new Button("Durchsuchen...");
        inputFolderButton.setOnAction(e -> this.chooseFile(primaryStage, this.inputFolderPathField));
        HBox inputFolderBox = new HBox(10.0, new Node[]{inputFolderLabel, this.inputFolderPathField, inputFolderButton});
        inputFolderBox.setPadding(new Insets(10.0));
        Label outputFolderLabel = new Label("Ausgabeordner:");
        this.outputFolderPathField = new TextField();
        this.outputFolderPathField.setPadding(new Insets(10.0));
        Button outputFolderButton = new Button("Durchsuchen...");
        outputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.outputFolderPathField));
        HBox outputFolderBox = new HBox(10.0, new Node[]{outputFolderLabel, this.outputFolderPathField, outputFolderButton});
        outputFolderBox.setPadding(new Insets(10.0));
        CheckBox pictures = new CheckBox("Bilder");
        pictures.setPadding(new Insets(10.0));
        CheckBox videos = new CheckBox("Videos");
        videos.setPadding(new Insets(10.0));
        Label sensitivityLabel = new Label("Sensitivit\u00e4t (Hamming-Distanz):");
        this.sensitivitySlider = new Slider(1.0, 50.0, 10.0);
        this.sensitivitySlider.setShowTickLabels(true);
        this.sensitivitySlider.setShowTickMarks(true);
        Label hashSizeLabel = new Label("Hash-Gr\u00f6\u00dfe:");
        this.hashSizeSlider = new Slider(8.0, 32.0, 8.0);
        this.hashSizeSlider.setShowTickLabels(true);
        this.hashSizeSlider.setShowTickMarks(true);
        ProgressBar progressBarPic = new ProgressBar(0.0);
        VBox progressBarBox = new VBox(10.0, new Node[]{progressBarPic});
        ProgressBar progressBarVid = new ProgressBar(0.0);
        VBox progressBarBoxVid = new VBox(10.0, new Node[]{progressBarVid});
        logArea = new TextArea();
        logArea.setEditable(false);
        logArea.setWrapText(true);
        VBox rootLA = new VBox(new Node[]{logArea});
        DataRecovery dataRec = new DataRecovery();
        Button startButton = new Button("Starten");
        startButton.setPadding(new Insets(10.0));
        startButton.setAlignment(Pos.CENTER);
        ChillModeUI cmu = new ChillModeUI();
        cmu.setProgressBarRecoverPic(progressBarPic);
        cmu.setProgressBarRecoverVid(progressBarVid);
        startButton.setOnAction(e -> dataRec.startRecovery(this.inputFolderPathField.getText(), this.outputFolderPathField.getText(), pictures.isSelected(), videos.isSelected(), logArea, cmu));
        layout.getChildren().addAll((Object[])new Node[]{inputFolderBox, outputFolderBox, pictures, videos, progressBarBox, progressBarBoxVid, startButton, logArea});
        tab.setContent((Node)layout);
        tab.setClosable(false);
        return tab;
    }

    private void chooseDirectory(Stage stage, TextField textField) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            textField.setText(selectedDirectory.getAbsolutePath());
        }
    }

    private void chooseFile(Stage stage, TextField textField) {
        FileChooser filechooser = new FileChooser();
        File selectedDirectory = filechooser.showOpenDialog((Window)stage);
        if (selectedDirectory != null) {
            textField.setText(selectedDirectory.getAbsolutePath());
        }
    }
}

