/*
 * Decompiled with CFR 0.152.
 */
package org.example.ui;

import java.io.File;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.example.logic.ChillModeUI;
import org.example.logic.DataRepairer;

public class DataRepairerTab {
    private TextField inputFolderPathField;
    private TextField outputFolderPathField;
    private static TextArea logArea;

    public Tab createTab(Stage primaryStage) {
        String imagePath = "disk_image.img";
        Tab tab = new Tab("Daten Reparieren");
        VBox layout = new VBox(10.0);
        Label instructions = new Label("Es wird ein Speicherabbild von dem angegebenen Ort gemacht");
        Label inputFolderLabel = new Label("Speicherort der Daten");
        this.inputFolderPathField = new TextField();
        Button inputFolderButton = new Button("Durchsuchen...");
        inputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.inputFolderPathField));
        HBox inputFolderBox = new HBox(10.0, new Node[]{inputFolderLabel, this.inputFolderPathField, inputFolderButton});
        inputFolderBox.setPadding(new Insets(10.0));
        Label outputFolderLabel = new Label("Speicherort der Daten");
        this.outputFolderPathField = new TextField();
        Button outputFolderButton = new Button("Durchsuchen...");
        inputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.outputFolderPathField));
        HBox outputFolderBox = new HBox(10.0, new Node[]{outputFolderLabel, this.outputFolderPathField, outputFolderButton});
        outputFolderBox.setPadding(new Insets(10.0));
        CheckBox pictures = new CheckBox("Bilder");
        pictures.setPadding(new Insets(10.0));
        CheckBox videos = new CheckBox("Videos");
        videos.setPadding(new Insets(10.0));
        ProgressBar progressBar = new ProgressBar(0.0);
        VBox root = new VBox(10.0, new Node[]{progressBar});
        Button startButton = new Button("Daten reparieren");
        TextField statusText = new TextField();
        statusText.setMinSize(10.0, 150.0);
        statusText.setDisable(true);
        logArea = new TextArea();
        logArea.setEditable(false);
        logArea.setWrapText(true);
        layout.getChildren().addAll((Object[])new Node[]{instructions, inputFolderBox, outputFolderBox, pictures, videos, logArea, root, startButton, statusText});
        startButton.setOnAction(e -> new Thread(() -> {
            DataRepairer delDABD = new DataRepairer(this.inputFolderPathField.getText(), this.outputFolderPathField.getText());
            startButton.setDisable(true);
            ChillModeUI cmu = new ChillModeUI();
            cmu.setProgressBarRepair(progressBar);
            delDABD.startRepair(this.inputFolderPathField.getText(), this.outputFolderPathField.getText(), pictures.isSelected(), videos.isSelected(), logArea, cmu);
        }).start());
        tab.setContent((Node)layout);
        tab.setClosable(false);
        return tab;
    }

    private void chooseDirectory(Stage stage, TextField textField) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            textField.setText(selectedDirectory.getAbsolutePath());
        }
    }
}

