/*
 * Decompiled with CFR 0.152.
 */
package org.example.ui;

import java.io.File;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.example.logic.ImageComparator;

public class ImageComparatorTab {
    private TextField inputFolderPathField;
    private TextField outputFolderPathField;
    private Slider sensitivitySlider;
    private Slider hashSizeSlider;

    public Tab createTab(Stage primaryStage) {
        Tab tab = new Tab("Bildvergleich");
        VBox layout = new VBox(10.0);
        Label inputFolderLabel = new Label("Eingabeordner:");
        this.inputFolderPathField = new TextField();
        Button inputFolderButton = new Button("Durchsuchen...");
        inputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.inputFolderPathField));
        HBox inputFolderBox = new HBox(10.0, new Node[]{inputFolderLabel, this.inputFolderPathField, inputFolderButton});
        inputFolderBox.setPadding(new Insets(10.0));
        Label outputFolderLabel = new Label("Ausgabeordner:");
        this.outputFolderPathField = new TextField();
        Button outputFolderButton = new Button("Durchsuchen...");
        outputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.outputFolderPathField));
        HBox outputFolderBox = new HBox(10.0, new Node[]{outputFolderLabel, this.outputFolderPathField, outputFolderButton});
        outputFolderBox.setPadding(new Insets(10.0));
        Label sensitivityLabel = new Label("Sensitivit\u00e4t (Hamming-Distanz):");
        this.sensitivitySlider = new Slider(1.0, 50.0, 10.0);
        this.sensitivitySlider.setShowTickLabels(true);
        this.sensitivitySlider.setShowTickMarks(true);
        Label hashSizeLabel = new Label("Hash-Gr\u00f6\u00dfe:");
        this.hashSizeSlider = new Slider(8.0, 32.0, 8.0);
        this.hashSizeSlider.setShowTickLabels(true);
        this.hashSizeSlider.setShowTickMarks(true);
        ImageComparator imgCre = new ImageComparator();
        Button startButton = new Button("Starten");
        startButton.setOnAction(e -> imgCre.startGrouping(this.inputFolderPathField.getText(), this.outputFolderPathField.getText(), (int)this.sensitivitySlider.getValue(), (int)this.hashSizeSlider.getValue()));
        layout.getChildren().addAll((Object[])new Node[]{inputFolderBox, outputFolderBox, sensitivityLabel, this.sensitivitySlider, hashSizeLabel, this.hashSizeSlider, startButton});
        tab.setContent((Node)layout);
        tab.setClosable(false);
        return tab;
    }

    private void chooseDirectory(Stage stage, TextField textField) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            textField.setText(selectedDirectory.getAbsolutePath());
        }
    }
}

