/*
 * Decompiled with CFR 0.152.
 */
package org.example.ui;

import java.io.File;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.example.logic.MemoryImageCreator;

public class MemoryImageTab {
    private TextField inputFolderPathField;

    public Tab createTab(Stage primaryStage) {
        String imagePath = "disk_image.img";
        Tab tab = new Tab("Speicherabbild");
        VBox layout = new VBox(10.0);
        Label instructions = new Label("Es wird ein Speicherabbild von dem angegebenen Ort gemacht");
        Label inputFolderLabel = new Label("Speicherort der Daten");
        this.inputFolderPathField = new TextField();
        Button inputFolderButton = new Button("Durchsuchen...");
        inputFolderButton.setOnAction(e -> this.chooseDirectory(primaryStage, this.inputFolderPathField));
        HBox inputFolderBox = new HBox(10.0, new Node[]{inputFolderLabel, this.inputFolderPathField, inputFolderButton});
        inputFolderBox.setPadding(new Insets(10.0));
        ProgressBar progressBar = new ProgressBar(0.0);
        VBox root = new VBox(10.0, new Node[]{progressBar});
        Button startButton = new Button("Speicherabbild erstellen");
        TextField statusText = new TextField();
        statusText.setMinSize(10.0, 150.0);
        statusText.setDisable(true);
        layout.getChildren().addAll((Object[])new Node[]{instructions, inputFolderBox, root, startButton, statusText});
        startButton.setOnAction(e -> new Thread(() -> {
            Object diskPath = "\\\\.\\" + this.inputFolderPathField.getText();
            diskPath = ((String)diskPath).substring(0, ((String)diskPath).length() - 1);
            MemoryImageCreator delDABD = new MemoryImageCreator((String)diskPath, imagePath);
            startButton.setDisable(true);
            delDABD.saveDiskImage((String)diskPath, imagePath, progress -> Platform.runLater(() -> {
                progressBar.setProgress((double)progress / 50.0);
                statusText.setText("Progress" + (double)progress / 50.0);
                if (progress == 50) {
                    startButton.setDisable(false);
                }
            }));
        }).start());
        tab.setContent((Node)layout);
        tab.setClosable(false);
        return tab;
    }

    private void chooseDirectory(Stage stage, TextField textField) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)stage);
        if (selectedDirectory != null) {
            textField.setText(selectedDirectory.getAbsolutePath());
        }
    }
}

